#!/usr/bin/env bash

# Parameters
env_names=("Humanoid-v2" "InvertedPendulum-v2" "InvertedDoublePendulum-v2" "Reacher-v2" "Swimmer-v2")
count=0

# Log file for job submissions
log_file="job_submission_log.txt"
> $log_file  # Clear the log file at the start

for env_name in "${env_names[@]}"; do
  for seed in {0..4}; do
    for steps in 2 4 8 16; do
    # Check if the model already exists
        sbatch --job-name="eval_model_${env_name}_${seed}_${steps}" eval_gru_model.sh $env_name $seed $steps
        echo "Submitted job for env=$env_name seed=$seed env=$steps" | tee -a $log_file
        count=$((count + 1))
      done
    done
done

echo "Launched $count jobs."
